using System;
using System.Collections.Generic;
using System.Linq;

namespace Projections
{
    class Program
    {
        static void Main(string[] args)
        {
            List<CalendarEvent> events = new List<CalendarEvent>
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            // Listing 8-18. Bardzo prosta projekcja.
            var projected = from ev in events
                            select ev;

            PrintEvents(projected);


            AnonTypes(events);


            var eventsByday = from ev in events
                              group ev by ev.StartTime.Date;

            // Listing 8-21. Spłaszczanie list przy użyciu kilku klauzul from.
            var items = from day in eventsByday
                        from item in day
                        select item;


            // Listing 8-22. Alternatywne zastosowanie dwóch klauzul from.
            int[] numbers = { 1, 2, 3, 4, 5 };
            var multiplied = from x in numbers
                             from y in numbers
                             select x * y;
            foreach (int n in multiplied)
            {
                Console.WriteLine(n);
            }

            // Listing 8-23. Numerowanie elementów.
            var numberedEvents = events.
                Select((ev, i) => string.Format("{0}: {1}", i + 1, ev.Title));
            foreach (string item in numberedEvents)
            {
                Console.WriteLine(item);
            }
        }

        private static void AnonTypes(List<CalendarEvent> events)
        {
            // Listing 8-19. Klauzula select tworząca typ anonimowy.
            var projected = from ev in events
                            select new
                            {
                                Title = ev.Title,
                                StartTime = ev.StartTime,
                                EndTime = ev.StartTime + ev.Duration
                            };

            // Listing 8-20. Korzystanie z kolekcji elementów typu anonimowego.
            foreach (var item in projected)
            {
                Console.WriteLine("Wydarzenie {0} zaczyna sie o {1} i kończy o {2}",
                item.Title, item.StartTime, item.EndTime);
            }
        }

        static void PrintEvents(IEnumerable<CalendarEvent> events)
        {
            foreach (CalendarEvent item in events)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }
        }
    }
}
